// Generic IO functions
#include <xc.h>

#ifndef _SETTINGS_H    /* Guard against multiple inclusion */
#define _SETTINGS_H

typedef enum {
    UART_MODE_MSMOUSE=1,    //identical to 7bit format (2 buttons only)
    UART_MODE_MSMOUSE_EXT,  //extended to 8 bits for more depth
    UART_MODE_ASCII         //text
}uartMode;

uartMode currentUartMode,newUartMode;
uint32_t currentBaudRate,newBaudRate;           
uint32_t currentDPIdivider,newDPIdivider;              //scaling for mouse movements
uint32_t currentUpdateInterval,newUpdateInterval;      //update interval in ms (0=> as fast as possible)

void defaultSettings();                     //load sensible defaults
void saveSettings();                        
void loadSettings();
void doSetupMenu();                         //main menu setup routine
void printMenu();

#endif // _SETTINGS_H
